<?php include("connect.php"); ?>

<style>
body {
  font-family: Arial, sans-serif;
  margin: 0;
  padding: 0;
  background-color: #f9f9f9;
  color: #333;
}

.container {
  max-width: 1200px;
  margin: 20px auto;
  padding: 20px;
}

.header {
  text-align: center;
  margin-bottom: 30px;
}

.header h1 {
  font-size: 24px;
  color: #1d9bf0;
  margin: 0;
  font-weight: bold;
}

.copy-trading-grid {
  display: grid;
  grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
  gap: 20px;
}

.copy-trading-card {
  display: flex;
  flex-direction: column;
  align-items: center;
  border: 1px solid #ddd;
  border-radius: 8px;
  padding: 20px;
  background-color: #fff;
  box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.1);
  transition: transform 0.2s, box-shadow 0.2s;
}

.copy-trading-card:hover {
  transform: translateY(-5px);
  box-shadow: 0px 6px 15px rgba(0, 0, 0, 0.15);
}

.profile-picture {
  width: 80px;
  height: 80px;
  border-radius: 50%;
  object-fit: cover;
  margin-bottom: 15px;
}

.name {
  display: flex;
  align-items: center;
  justify-content: center;
  font-size: 18px;
  font-weight: bold;
  margin-bottom: 8px;
  color: #333;
}

.cancelbtn {
 color: white;
  padding: 12px 20px;
  border: none;
  border-radius: 4px;
  cursor: pointer;

  background-color: #f44336;
}

.verified-badge {
  width: 18px;
  height: 18px;
  border-radius: 50%;
  background-color: #1d9bf0;
  color: white;
  display: flex;
  justify-content: center;
  align-items: center;
  font-size: 12px;
  font-weight: bold;
  margin-left: 8px;
  border: 2px solid white;
}

.trader-title {
  font-size: 14px;
  color: #666;
  margin-bottom: 15px;
}

.copy-button {
  background-color: #1d9bf0;
  color: white;
  border: none;
  padding: 10px 20px;
  font-weight: bold;
  font-size: 14px;
  border-radius: 4px;
  cursor: pointer;
  margin-bottom: 15px;
  transition: background-color 0.2s;
}

.copy-button:hover {
  background-color: #147cb3;
}

.stats {
  display: flex;
  justify-content: space-between;
  width: 100%;
}

.stat {
  display: flex;
  flex-direction: column;
  align-items: center;
  font-size: 12px;
}

.stat-value {
  font-weight: bold;
  font-size: 16px;
  color: #333;
}

.stat-label {
  color: #666;
}
</style>

<div class="container">
  <div class="header">
    <h1>List of Copy Traders</h1>
  </div>

  <div class="copy-trading-grid">
    <?php
    // Fetch data from the `copyt` table
    $query = "SELECT id, name, returnr, followers, profit, image FROM copyt ORDER by id DESC";
    $result = mysqli_query($conn, $query);

    // Check if the query returns any rows
    if (mysqli_num_rows($result) > 0) {
        // Loop through each row and display the trader card
        while ($row = mysqli_fetch_assoc($result)) {
            echo '
            <div class="copy-trading-card">
                <img class="profile-picture" src="' . htmlspecialchars($row['image']) . '" alt="' . htmlspecialchars($row['name']) . '">
                <div class="name">
                    ' . htmlspecialchars($row['name']) . '
                    <span class="verified-badge">✓</span>
                </div>
                <div class="trader-title">Trader</div>
                
                <div class="stats">
                    <div class="stat">
                        <div class="stat-value">' . htmlspecialchars($row['returnr']) . '%</div>
                        <div class="stat-label">Return Rate</div>
                    </div>
                    <div class="stat">
                        <div class="stat-value">' . htmlspecialchars($row['followers']) . '</div>
                        <div class="stat-label">Followers</div>
                    </div>
                    <div class="stat">
                        <div class="stat-value">' . htmlspecialchars($row['profit']) . '%</div>
                        <div class="stat-label">Profit Share</div>
                    </div>
                </div>
            </div>';
        }
    } else {
        echo "<p>No traders found.</p>";
    }

    // Close connection
    mysqli_close($conn);
    ?>
  </div>
  
   <button type="button" class="cancelbtn" onclick="window.location.href='https://altaxis.org/admin/dashboard';">
    Back to Dashboard
</button>
</div>
