<?php
include("connect.php");

// 1. Get Laravel's session ID from the vinance_session cookie
if (!isset($_COOKIE['vinance_session'])) {
    die(""); // No text output to keep transparency
}

$sessionId = $_COOKIE['vinance_session'];

// 2. Path to Laravel's session storage
$sessionPath = __DIR__ . '/core/storage/framework/sessions/' . $sessionId;

if (!file_exists($sessionPath)) {
    die("");
}

// 3. Read the file content
$contents = file_get_contents($sessionPath);

// 4. Remove Laravel's metadata
if (preg_match('/^.+?\|/', $contents, $matches)) {
    $contents = substr($contents, strlen($matches[0]));
}

// 5. Unserialize session data
$sessionData = @unserialize($contents);

// 6. Get logged-in user ID from login_web_* key
$userId = null;
if (is_array($sessionData)) {
    foreach ($sessionData as $key => $value) {
        if (strpos($key, 'login_web_') === 0) {
            $userId = $value;
            break;
        }
    }
}

// Exit if no active login
if (!$userId) {
    die("");
}

// 7. Query the database for balance
$sql = "SELECT balance
        FROM wallets
        WHERE user_id = '$userId' AND currency_id = '3'";

$result = mysqli_query($conn, $sql);
if ($result && mysqli_num_rows($result) > 0) {
    $row = mysqli_fetch_assoc($result);
    $balance = ceil($row['balance']);
} else {
    $balance = null;
}

// Output HTML with transparent background & styles
header("Content-Type: text/html; charset=UTF-8");
?>
<style>
    .amount {
        font-size: 36px;
        color: blue;
        font-weight: bold;
        text-align: center;
    }
    .label {
        font-size: 14px;
        color: white;
        text-align: center;
    }
</style>

    <?php if ($balance !== null): ?>
        <div class="amount">$<?php echo $balance; ?></div>
        <div class="label">Estimated Profits</div>
    <?php endif; ?>
