<?php $__env->startSection('content'); ?>
<div class="row gy-4">
    <div class="col-12">
        <h4 class="mb-0"><?php echo e(__($pageTitle)); ?></h4>
    </div>
    <?php if($user->referrer): ?>
    <div class="col-md-12">
        <div class="card">
            <div class="card-body">
                <h4><?php echo app('translator')->get('You are referred by'); ?> <span class="text--base"><?php echo e(@$user->referrer->fullname); ?></span></h4>
            </div>
        </div>
    </div>
    <?php endif; ?>
    <div class="col-md-12">
        <?php if($user->allReferrals->count() > 0 && $maxLevel > 0): ?>
            <div class="card">
                <div class="card-header">
                    <h5 class="text-start"> <?php echo app('translator')->get('Users Referred By Me'); ?></h5>
                </div>
                <div class="card-body">
                    <div class="treeview-container">
                        <ul class="treeview">
                            <li class="items-expanded"> <?php echo e($user->fullname); ?> ( <?php echo e($user->username); ?> )
                                <?php echo $__env->make($activeTemplate . 'partials.under_tree', [
                                    'user'    => $user,
                                    'layer'   => 0,
                                    'isFirst' => true,
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        <?php else: ?>
        <div class="card">
            <div class="card-body p-5">
                <div class="empty-thumb text-center">
                    <img src="<?php echo e(asset('assets/images/extra_images/empty.png')); ?>" />
                    <p class="fs-14"><?php echo app('translator')->get('No data found'); ?></p>
                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style-lib'); ?>
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue . 'dashboard/css/jquery.treeView.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset($activeTemplateTrue . 'dashboard/js/jquery.treeView.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('.treeview').treeView();
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/altabxhp/public_html/core/resources/views/templates/basic/user/referrals.blade.php ENDPATH**/ ?>