<thead>
    <tr>
        <th><?php echo app('translator')->get('TRX | Coin Pair'); ?></th>
        <th><?php echo app('translator')->get('Trade Date'); ?></th>
        <th><?php echo app('translator')->get('Invest'); ?></th>
        <th><?php echo app('translator')->get('Duration'); ?></th>
        <th><?php echo app('translator')->get('Direction'); ?></th>
        <th><?php echo app('translator')->get('Win Amount'); ?></th>
        <th><?php echo app('translator')->get('Win Status'); ?></th>
    </tr>
</thead>
<tbody>
    <?php $__empty_1 = true; $__currentLoopData = $trades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trade): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <tr>
            <td>
                <div>
                    <?php echo e($trade->trx); ?>

                    <br>
                    <?php echo e(@$trade->coinPair->symbol); ?>

                </div>
            </td>
            <td><?php echo e(showDateTime($trade->created_at)); ?></td>
            <td> <?php echo e(showAmount($trade->amount, currencyFormat: false)); ?> <?php echo e(__(@$trade->coinPair->coin->symbol)); ?></td>
            <td><?php echo convertToMinutesSeconds($trade->duration)  ?></td>
            <td>
                <?php echo e(__($trade->direction)); ?>

                <span>
                    <?php if($trade->direction == 'higher'): ?>
                        <i class="las la-arrow-up text--success"></i>
                    <?php else: ?>
                        <i class="las la-arrow-down text--danger"></i>
                    <?php endif; ?>
                </span>
            </td>
            <td>
                <?php if($trade->win_status == Status::BINARY_TRADE_WIN): ?>
                    <span class="text--success"><?php echo e(showAmount($trade->win_amount, currencyFormat: false)); ?> <?php echo e(__(@$trade->coinPair->coin->symbol)); ?></span>
                <?php elseif($trade->win_status == Status::BINARY_TRADE_LOSE): ?>
                    <span class="text--danger"><?php echo e(showAmount($trade->win_amount, currencyFormat: false)); ?> <?php echo e(__(@$trade->coinPair->coin->symbol)); ?></span>
                <?php else: ?>
                    <?php echo e(showAmount($trade->win_amount, currencyFormat: false)); ?> <?php echo e(__(@$trade->coinPair->coin->symbol)); ?>

                <?php endif; ?>
            </td>
            <td>
                <?php
                    echo $trade->winStatusBadge;
                ?>
            </td>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <?php echo userTableEmptyMessage('trade') ?>
    <?php endif; ?>
</tbody>
<?php /**PATH /home/altabxhp/public_html/core/resources/views/templates/basic/partials/binary_table.blade.php ENDPATH**/ ?>