<?php
    $highLightedCoins = App\Models\Currency::active()
        ->crypto()
        ->where('highlighted_coin', Status::YES)
        ->with('marketData')
        ->rankOrdering()
        ->take(4)
        ->get();
?>
<div class="market-overview-card">
    <div class="market-overview-card__header">
        <h6 class="mb-2"><?php echo app('translator')->get('Highlight Coin'); ?></h6>
    </div>
    <div class="market-overview-card__list">
        <?php $__empty_1 = true; $__currentLoopData = $highLightedCoins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $highLightedCoin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="market-overview-card__item">
                <span class="coin-name">
                    <img src="<?php echo e(@$highLightedCoin->image_url); ?>">
                    <?php echo e(@$highLightedCoin->symbol); ?>

                </span>
                <span class="coin-text">
                    <span class="market-price-symbol-<?php echo e(@$highLightedCoin->marketData->id); ?> <?php echo e(@$highLightedCoin->marketData->html_classes->price_change); ?>">
                        <?php echo e(gs('cur_sym')); ?>

                    </span><span class="market-price-<?php echo e(@$highLightedCoin->marketData->id); ?> <?php echo e(@$highLightedCoin->marketData->html_classes->price_change); ?>">
                        <?php echo e(showAmount(@$highLightedCoin->marketData->price,currencyFormat:false)); ?>

                    </span>
                </span>
                <span class="coin-percentage">
                    <span
                        class="market-percent-change-1h-<?php echo e(@$highLightedCoin->marketData->id); ?> <?php echo e(@$highLightedCoin->marketData->html_classes->percent_change_1h); ?>">
                        <?php echo e(getAmount(@$highLightedCoin->marketData->percent_change_1h)); ?>%
                    </span>
                </span>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="empty-thumb text-center">
                <img src="<?php echo e(asset('assets/images/extra_images/empty.png')); ?>" />
                <p class="fs-14"><?php echo app('translator')->get('No coin found'); ?></p>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php /**PATH /home/altabxhp/public_html/core/resources/views/templates/basic/coin/highlight_coin.blade.php ENDPATH**/ ?>