<?php $__env->startSection('content'); ?>
<div class="row justify-content-between gy-4 align-items-center">
    <div class="col-lg-3">
        <h4 class="mb-0"><?php echo e(__($pageTitle)); ?></h4>
    </div>
    <div class="col-lg-4">
        <div class="text-end">
            <a href="<?php echo e(route('ticket.open')); ?>" class="btn btn--sm btn--base outline">
                <i class="las la-plus"></i><?php echo app('translator')->get('New Ticket'); ?>
            </a>
        </div>
    </div>
   
    <div class="col-md-12">
        <div class="table-wrapper">
            <table class="table table--responsive--lg">
                <thead>
                    <tr>
                        <th><?php echo app('translator')->get('Subject'); ?></th>
                        <th><?php echo app('translator')->get('Status'); ?></th>
                        <th><?php echo app('translator')->get('Priority'); ?></th>
                        <th><?php echo app('translator')->get('Last Reply'); ?></th>
                        <th><?php echo app('translator')->get('Action'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $supports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $support): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td>
                            <a href="<?php echo e(route('ticket.view', $support->ticket)); ?>" class="fw-bold">
                                 [<?php echo app('translator')->get('Ticket'); ?>#<?php echo e($support->ticket); ?>] <?php echo e(__($support->subject)); ?> </a>
                            </td>
                        <td>
                            <?php echo $support->statusBadge; ?>
                        </td>
                        <td>
                            <?php if($support->priority == Status::PRIORITY_LOW): ?>
                            <span class="badge badge--dark"><?php echo app('translator')->get('Low'); ?></span>
                            <?php elseif($support->priority == Status::PRIORITY_MEDIUM): ?>
                            <span class="badge  badge--warning"><?php echo app('translator')->get('Medium'); ?></span>
                            <?php elseif($support->priority == Status::PRIORITY_HIGH): ?>
                            <span class="badge badge--danger"><?php echo app('translator')->get('High'); ?></span>
                            <?php endif; ?>
                        </td>
                        <td><?php echo e(diffForHumans($support->last_reply)); ?> </td>
                        <td>
                            <a href="<?php echo e(route('ticket.view', $support->ticket)); ?>" class="btn btn--base btn--sm outline">
                                <i class="las la-desktop"></i> <?php echo app('translator')->get('Details'); ?>
                            </a>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <?php echo userTableEmptyMessage('support ticket') ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <?php if($supports->hasPages()): ?>
            <?php echo e(paginateLinks($supports)); ?>

        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate.'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/altabxhp/public_html/core/resources/views/templates/basic/user/support/index.blade.php ENDPATH**/ ?>