<?php $__env->startSection('content'); ?>
<div class="row justify-content-between gy-3 align-items-center">
    <div class="col-lg-4">
        <h4 class="mb-0"><?php echo e(__($pageTitle)); ?></h4>
    </div>
    <div class="col-lg-4">
        <form class="d-flex gap-2 flex-wrap">
            <div class="flex-fill position-relative">
               <select class="form-control form--control submit-form-on-change form-select select2" name="trade_side" 
               data-minimum-results-for-search="-1" data-width="100%">
                    <option value="" selected disabled><?php echo app('translator')->get('Trade Side'); ?></option>
                    <option value=""><?php echo app('translator')->get('All'); ?></option>
                    <option value="<?php echo e(Status::BUY_SIDE_TRADE); ?>" <?php if(request()->trade_side ==  Status::BUY_SIDE_TRADE): echo 'selected'; endif; ?>><?php echo app('translator')->get('Buy'); ?></option>
                    <option value="<?php echo e(Status::SELL_SIDE_TRADE); ?>" <?php if(request()->trade_side ==  Status::SELL_SIDE_TRADE): echo 'selected'; endif; ?>><?php echo app('translator')->get('Sell'); ?></option>
               </select>
            </div>
            <div class="flex-fill">
                <div class="input-group">
                    <input type="text" name="search" class="form-control form--control" value="<?php echo e(request()->search); ?>" placeholder="<?php echo app('translator')->get('Pair,coin,currency...'); ?>">
                    <button type="submit" class="input-group-text bg-primary text-white">
                        <i class="las la-search"></i>
                    </button>
                </div>
            </div>
        </form>
    </div>
    <div class="col-lg-12">
        <div class="table-wrapper">
            <table class="table table--responsive--lg">
                <thead>
                    <tr>
                        <th><?php echo app('translator')->get('Order Date | Pair'); ?></th>
                        <th><?php echo app('translator')->get('Trade Date'); ?></th>
                        <th><?php echo app('translator')->get('Trade Side'); ?></th>
                        <th><?php echo app('translator')->get('Rate'); ?></th>
                        <th><?php echo app('translator')->get('Amount'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $trades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trade): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td>
                            <div>
                                <?php echo e($trade->order->formatted_date); ?>

                                <br>
                                <?php echo e(@$trade->order->pair->symbol); ?>

                            </div>
                        </td>
                        <td><?php echo e(showDateTime($trade->created_at)); ?></td>
                        <td> <?php  echo $trade->tradeSideBadge; ?> </td>
                        <td>
                            <?php echo e(showAmount($trade->rate,currencyFormat:false)); ?> <?php echo e(@$trade->order->pair->market->currency->symbol); ?>

                        </td>
                        <td> <?php echo e(showAmount($trade->amount,currencyFormat:false)); ?> <?php echo e(@$trade->order->pair->coin->symbol); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <?php echo userTableEmptyMessage('trade') ?>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>



<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset('assets/global/js/select2.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('style-lib'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/global/css/select2.min.css')); ?>">
<?php $__env->stopPush(); ?>



<?php echo $__env->make($activeTemplate.'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/altabxhp/public_html/core/resources/views/templates/basic/user/order/trade_history.blade.php ENDPATH**/ ?>