<?php
    $newCoins = App\Models\Currency::active()->crypto()->rankOrdering()->with('marketData')->take(4)->get();
?>

<div class="market-overview-card">
    <div class="market-overview-card__header">
        <h6 class="mb-2"><?php echo app('translator')->get('New Coin'); ?></h6>
    </div>
    <div class="market-overview-card__list">
        <?php $__empty_1 = true; $__currentLoopData = $newCoins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $newCoin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="market-overview-card__item">
                <span class="coin-name">
                    <img src="<?php echo e(@$newCoin->image_url); ?>">
                    <?php echo e(@$newCoin->symbol); ?>

                </span>
                <span class="coin-text">
                    <span class="market-price-symbol-<?php echo e(@$newCoin->marketData->id); ?> <?php echo e(@$newCoin->marketData->html_classes->price_change); ?>">
                        <?php echo e(gs("cur_sym")); ?>

                    </span><span class="market-price-<?php echo e(@$newCoin->marketData->id); ?> <?php echo e(@$newCoin->marketData->html_classes->price_change); ?>">
                        <?php echo e(showAmount(@$newCoin->marketData->price,currencyFormat:false)); ?>

                    </span>
                </span>
                <span class="coin-percentage">
                    <span class="market-percent-change-1h-<?php echo e(@$newCoin->marketData->id); ?> <?php echo e(@$newCoin->marketData->html_classes->percent_change_1h); ?>">
                        <?php echo e(getAmount(@$newCoin->marketData->percent_change_1h)); ?>%
                    </span>
                </span>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="empty-thumb text-center">
                <img src="<?php echo e(asset('assets/images/extra_images/empty.png')); ?>" />
                <p class="fs-14"><?php echo app('translator')->get('No coin found'); ?></p>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php /**PATH /home/altabxhp/public_html/core/resources/views/templates/basic/coin/new_coin.blade.php ENDPATH**/ ?>