<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="card ">
                <div class="card-body">
                    <form action="<?php echo e(route('admin.coin.pair.save', @$coinPair->id)); ?>" method="POST" enctype="multipart/form-data" class="pair-form">
                        <?php echo csrf_field(); ?>
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-sm-6">
                                    <div class="form-group position-relative" id="currency_list_wrapper">
                                        <label><?php echo app('translator')->get('Coin'); ?></label>
                                        <?php if (isset($component)) { $__componentOriginal088acdb7de35136e27c18e45a357b6f7 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal088acdb7de35136e27c18e45a357b6f7 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.currency-list','data' => ['name' => 'coin','type' => Status::CRYPTO_CURRENCY,'disabled' => @$coinPair ? true : false]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('currency-list'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => 'coin','type' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(Status::CRYPTO_CURRENCY),'disabled' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(@$coinPair ? true : false)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal088acdb7de35136e27c18e45a357b6f7)): ?>
<?php $attributes = $__attributesOriginal088acdb7de35136e27c18e45a357b6f7; ?>
<?php unset($__attributesOriginal088acdb7de35136e27c18e45a357b6f7); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal088acdb7de35136e27c18e45a357b6f7)): ?>
<?php $component = $__componentOriginal088acdb7de35136e27c18e45a357b6f7; ?>
<?php unset($__componentOriginal088acdb7de35136e27c18e45a357b6f7); ?>
<?php endif; ?>
                                    </div>
                                </div>
                                <div class="form-group col-sm-6 position-relative" id="market-list">
                                    <label><?php echo app('translator')->get('Market'); ?></label>
                                    <select class="form-control" required name="market" <?php if(@$coinPair): echo 'disabled'; endif; ?>>
                                        <option selected disabled><?php echo app('translator')->get('Select One'); ?></option>
                                        <?php
                                            $selecetdMarketId = old('market', @$coinPair->market_id) ? old('market', @$coinPair->market_id) : request()->market_id ?? '';
                                        ?>
                                        <?php $__currentLoopData = $markets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $market): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($market->id); ?>" data-cur-sym="<?php echo e($market->currency->symbol); ?>"
                                                    <?php if($market->id == $selecetdMarketId): echo 'selected'; endif; ?>>
                                                <?php echo e(__($market->name)); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label><?php echo app('translator')->get('Minimum Buy Amount'); ?></label>
                                    <small title="<?php echo app('translator')->get('The minimum buy amount is the smallest quantity required to buy coin on this pair.'); ?>"><i class="las la-info-circle"></i></small>
                                    <div class="input-group appnend-coin-sym">
                                        <input type="number" step="any" class="form-control" name="minimum_buy_amount"
                                               value="<?php echo e(old('minimum_buy_amount', @$coinPair ? getAmount(@$coinPair->minimum_buy_amount) : '')); ?>" required>
                                    </div>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label><?php echo app('translator')->get('Maximum Buy Amount'); ?></label>
                                    <small title="<?php echo app('translator')->get('The maximum buy amount is the highest quantity of coin to buy on this pair. Use -1 for no maximum limit.'); ?>"><i class="las la-info-circle"></i></small>
                                    <div class="input-group appnend-coin-sym">
                                        <input type="number" step="any" class="form-control" name="maximum_buy_amount"
                                               value="<?php echo e(old('maximum_buy_amount', @$coinPair ? getAmount(@$coinPair->maximum_buy_amount) : '')); ?>" required>
                                    </div>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label><?php echo app('translator')->get('Minimum Sell Amount'); ?></label>
                                    <small title="<?php echo app('translator')->get('The minimum sell amount is the smallest quantity required to sell coin on this pair.'); ?>"><i class="las la-info-circle"></i></small>
                                    <div class="input-group appnend-coin-sym">
                                        <input type="number" step="any" class="form-control" name="minimum_sell_amount"
                                               value="<?php echo e(old('minimum_sell_amount', @$coinPair ? getAmount(@$coinPair->minimum_sell_amount) : '')); ?>" required>
                                    </div>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label><?php echo app('translator')->get('Maximum Sell Amount'); ?></label>
                                    <small title="<?php echo app('translator')->get('The maximum sell amount is the highest quantity of coin to sell on this pair. Use -1 for no maximum limit.'); ?>"><i class="las la-info-circle"></i></small>
                                    <div class="input-group appnend-coin-sym">
                                        <input type="number" step="any" class="form-control" name="maximum_sell_amount"
                                               value="<?php echo e(old('maximum_sell_amount', @$coinPair ? getAmount(@$coinPair->maximum_sell_amount) : '')); ?>" required>
                                    </div>
                                </div>
                                <div class="form-group col-sm-6 col-md-4">
                                    <label><?php echo app('translator')->get('Percent Charge For Buy'); ?></label>
                                    <small title="<?php echo app('translator')->get('Set applicable percent charge for the buy of coin on this pair.'); ?>"><i class="las la-info-circle"></i></small>
                                    <div class="input-group">
                                        <input type="number" step="any" class="form-control" name="percent_charge_for_buy"
                                               value="<?php echo e(old('percent_charge_for_buy', @$coinPair ? getAmount(@$coinPair->percent_charge_for_buy) : '')); ?>" required>
                                        <span class="input-group-text">%</span>
                                    </div>
                                </div>
                                <div class="form-group col-sm-6 col-md-4">
                                    <label><?php echo app('translator')->get('Percent Charge For Sell'); ?></label>
                                    <small title="<?php echo app('translator')->get('Set applicable percent charge for the sell of coin on this pair.'); ?>"><i class="las la-info-circle"></i></small>
                                    <div class="input-group">
                                        <input type="number" step="any" class="form-control" name="percent_charge_for_sell"
                                               value="<?php echo e(old('percent_charge_for_sell', @$coinPair ? getAmount(@$coinPair->percent_charge_for_sell) : '')); ?>" required>
                                        <span class="input-group-text">%</span>
                                    </div>
                                </div>

                                <div class="form-group col-sm-4">
                                    <label><?php echo app('translator')->get('Listed Market'); ?></label>
                                    <small title="<?php echo app('translator')->get('Set the listed market name where this coin pair is listed.'); ?>"><i class="las la-info-circle"></i></small>
                                    <input type="text" class="form-control" name="listed_market_name"
                                           value="<?php echo e(old('listed_market_name', @$coinPair->listed_market_name)); ?>">
                                </div>
                                <div class="form-group col-sm-4">
                                    <label for="inputName"><?php echo app('translator')->get('Choose Trade Type'); ?><span class="text--danger">*</span></label>
                                    <select class="form-control" name="type" required>
                                        <option value="1" <?php if(@$coinPair->type == Status::SPOT_TRADE): echo 'selected'; endif; ?>><?php echo app('translator')->get('Spot Trade'); ?></option>
                                        <option value="2" <?php if(@$coinPair->type == Status::BINARY_TRADE): echo 'selected'; endif; ?>><?php echo app('translator')->get('Binary Trade'); ?></option>
                                        <option value="3" <?php if(@$coinPair->type == Status::BOTH_TRADE): echo 'selected'; endif; ?>><?php echo app('translator')->get('Both Trade'); ?></option>
                                    </select>
                                </div>
                                <div class="form-group col-sm-4">
                                    <label for="inputName"><?php echo app('translator')->get('Default Pair'); ?></label>
                                    <input type="checkbox" <?php if(@$coinPair->is_default): echo 'checked'; endif; ?> data-width="100%" data-height="40px" data-onstyle="-success"
                                           data-offstyle="-danger" data-bs-toggle="toggle" data-on="<?php echo app('translator')->get('YES'); ?>" data-off="<?php echo app('translator')->get('NO'); ?>"
                                           name="is_default">
                                </div>
                            </div>

                            <h6 class="my-3"><?php echo app('translator')->get('Binary Trade'); ?></h6>
                            <div class="row">
                                <div class="form-group col-xl-3 col-sm-6">
                                    <label><?php echo app('translator')->get('Minimum Trade Amount'); ?></label>
                                    <small title="<?php echo app('translator')->get('The minimum binary trade amount is the smallest quantity required to buy coin on this pair.'); ?>"><i class="las la-info-circle"></i></small>
                                    <div class="input-group appnend-coin-sym">
                                        <input type="number" step="any" class="form-control" name="min_binary_trade_amount"
                                               value="<?php echo e(old('min_binary_trade_amount', @$coinPair ? getAmount(@$coinPair->min_binary_trade_amount) : '')); ?>" required>
                                    </div>
                                </div>
                                <div class="form-group col-xl-3 col-sm-6">
                                    <label><?php echo app('translator')->get('Maximum Trade Amount'); ?></label>
                                    <small title="<?php echo app('translator')->get('The maximum binary trade amount is the highest quantity of coin to buy on this pair. Use -1 for no maximum limit.'); ?>"><i class="las la-info-circle"></i></small>
                                    <div class="input-group appnend-coin-sym">
                                        <input type="number" step="any" class="form-control" name="max_binary_trade_amount"
                                               value="<?php echo e(old('max_binary_trade_amount', @$coinPair ? getAmount(@$coinPair->max_binary_trade_amount) : '')); ?>" required>
                                    </div>
                                </div>
                                <div class="form-group col-xl-3 col-sm-6">
                                    <label><?php echo app('translator')->get('Increment Amount'); ?></label>
                                    <div class="input-group appnend-coin-sym">
                                        <input type="number" step="any" class="form-control" name="binary_increment_amount"
                                               value="<?php echo e(old('binary_increment_amount', @$coinPair ? getAmount(@$coinPair->binary_increment_amount) : '')); ?>" required>
                                    </div>
                                </div>
                                <div class="form-group col-xl-3 col-sm-6">
                                    <label><?php echo app('translator')->get('Profit of Binary Trade'); ?></label>
                                    <small title="<?php echo app('translator')->get('Set applicable percent charge for the binary trade of coin on this pair.'); ?>"><i class="las la-info-circle"></i></small>
                                    <div class="input-group">
                                        <input type="number" step="any" class="form-control" name="binary_trade_profit"
                                               value="<?php echo e(old('binary_trade_profit', @$coinPair ? getAmount(@$coinPair->binary_trade_profit) : '')); ?>" required>
                                        <span class="input-group-text">%</span>
                                    </div>
                                </div>
                            </div>

                            <div class="my-3 d-flex justify-content-between flex-wrap align-items-center">
                                <h6><?php echo app('translator')->get('Binary Trade Duration'); ?></h6>
                                <button type="button" class="btn btn-outline--primary addDuration"><i class="las la-plus"></i> <?php echo app('translator')->get('Add More'); ?></button>
                            </div>

                            <div class="row duration-area">
                                <div class="form-group col-sm-4">
                                    <label><?php echo app('translator')->get('Duration'); ?><span class="text--danger">*</span></label>
                                    <div class="input-group">
                                        <input type="number" name="binary_trade_duration[]" min="1" value="<?php echo e(@$coinPair->binary_trade_duration[0]); ?>" placeholder="<?php echo app('translator')->get('Duration in seconds'); ?>" class="form-control">
                                        <span class="input-group-text"><?php echo app('translator')->get('seconds'); ?></span>
                                    </div>
                                </div>
                                <?php $__currentLoopData = @$coinPair->binary_trade_duration ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $duration): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($loop->first): ?>
                                        <?php continue; ?>
                                    <?php endif; ?>
                                    <div class="form-group col-sm-4">
                                        <label><?php echo app('translator')->get('Duration'); ?><span class="text--danger">*</span></label>
                                        <div class="input-group">
                                            <input type="number" name="binary_trade_duration[]" min="1" value="<?php echo e($duration); ?>" placeholder="<?php echo app('translator')->get('Duration in seconds'); ?>" class="form-control">
                                            <span class="input-group-text"><?php echo app('translator')->get('seconds'); ?></span>
                                            <button type="button" class="input-group-text bg--red text-white border-0 removeDuration"><i class="las la-times"></i></button>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                            <button type="submit" class="btn btn--primary w-100 h-45 "><?php echo app('translator')->get('Submit'); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('breadcrumb-plugins'); ?>
    <a href="<?php echo e(route('admin.coin.pair.list')); ?>" class="btn btn-outline--primary btn-sm">
        <i class="las la-list"></i><?php echo app('translator')->get('Coin Pair List'); ?>
    </a>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        "use strict";
        (function($) {

            <?php if(@$coinPair): ?>
                let newOption = new Option("<?php echo e(@$coinPair->coin->symbol); ?>-<?php echo e(@$coinPair->coin->name); ?>", "<?php echo e(@$coinPair->coin_id); ?>", true, true);
                $('#currency_list').append(newOption).trigger('change');
                $("select[name=coin]").attr('readonly', true);
                coinSym("<?php echo e(@$coinPair->coin->symbol); ?>");
            <?php endif; ?>

            $('select[name=coin]').on('change', function(e) {
                let coin = $(this).find('option:selected').text().split('-');
                let symbol = coin.pop();
                coinSym(symbol)
            });

            function coinSym(coinSym) {
                $.each($('.appnend-coin-sym'), function(i, element) {
                    let symbolHtml = $(element).find('.input-group-text');
                    if (symbolHtml.length) {
                        symbolHtml.text(coinSym)
                    } else {
                        $(element).append(`<span class="input-group-text">${coinSym}</span>`)
                    }
                });
            };

            $("select[name=market]").select2({
                dropdownParent: $("#market-list")
            });

            $('.addDuration').on('click', function(e) {
                e.preventDefault();
                var durationArea = $('.duration-area');
                var durationHtml = `<div class="form-group col-sm-4">
                                <label><?php echo app('translator')->get('Duration'); ?><span class="text--danger">*</span></label>
                                <div class="input-group">
                                    <input type="number" name="binary_trade_duration[]" min="1" placeholder="<?php echo app('translator')->get('Duration in seconds'); ?>" class="form-control">
                                    <span class="input-group-text"><?php echo app('translator')->get('seconds'); ?></span>
                                    <button type="button" class="input-group-text bg--red text-white border-0 removeDuration"><i class="las la-times"></i></button>
                                </div>
                            </div>`;
                durationArea.append(durationHtml);
            });

            $(document).on('click', '.removeDuration', function(e) {
                e.preventDefault();
                $(this).closest('.form-group').remove();
            });


        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>


<?php $__env->startPush('style'); ?>
    <style>
        .select2-container {
            z-index: 97 !important;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/altabxhp/public_html/core/resources/views/admin/coin_pair/create.blade.php ENDPATH**/ ?>