<?php
    $meta = (object) $meta;
    $gateways = $meta->gateways;
    $singleCurrency = @$meta->single_currency ?? null;
    $walletType = @$meta->wallet_type ?? null;
?>
<div class="offcanvas offcanvas-end p-5" tabindex="-1" id="deposit-canvas" aria-labelledby="offcanvasLabel">
    <div class="offcanvas-header">
        <h4 class="mb-0 fs-18 offcanvas-title">
            <?php echo app('translator')->get('Deposit Preview'); ?>
        </h4>
        <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close">
            <i class="fa fa-times-circle"></i>
        </button>
    </div>
    <div class="offcanvas-body">
        <form action="<?php echo e(route('user.deposit.insert')); ?>" method="post" class="<?php if($gateways->count() <= 0): ?> d-none <?php endif; ?>">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="currency" value="<?php echo e(@$singleCurrency->symbol); ?>">
            <div class="form-group">
                <label class="form-label"><?php echo app('translator')->get('Amount'); ?></label>
                <div class="input-group">
                    <input type="number" step="any" class="form--control form-control" name="amount" required>
                    <span class="input-group-text text-white deposit-currency-symbol"><?php echo e(__(@$singleCurrency->symbol)); ?></span>
                </div>
            </div>
            <div class="form-group position-relative">
                <label class="form-label"><?php echo app('translator')->get('Gateway'); ?></label>
                <select class="form-control form--control form-select select2" name="gateway" required
                    data-minimum-results-for-search="-1">
                    <?php if(@$singleCurrency): ?>
                        <?php $__currentLoopData = $gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($gateway->method_code); ?>" data-gateway='<?php echo json_encode($gateway, 15, 512) ?>'
                                data-image-src="<?php echo e(getImage(getFilePath('gateway') . '/' . @$gateway->method->image)); ?>">
                                <?php echo e(__($gateway->name)); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </select>
            </div>
            <?php if($walletType): ?>
                <input type="hidden" name="wallet_type" value="<?php echo e($walletType); ?>">
            <?php else: ?>
                <div class="form-group position-relative">
                    <label class="form-label"><?php echo app('translator')->get('Wallet Type'); ?></label>
                    <select class="form-control form--control form-select canvas-select2" data-minimum-results-for-search="-1" name="wallet_type"
                        required>
                        <option value="" selected disabled><?php echo app('translator')->get('Select One'); ?></option>
                        <?php $__currentLoopData = gs('wallet_types'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $walletType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if(checkWalletConfiguration($k, 'deposit')): ?>
                                <option value="<?php echo e($k); ?>"><?php echo e(__($walletType->title)); ?></option>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            <?php endif; ?>
            <div class="form-group preview-details d-none">
                <ul class="list-group list-group-flush">
                    <li class="list-group-item d-flex flex-wrap justify-content-between">
                        <span><?php echo app('translator')->get('Limit'); ?></span>
                        <span>
                            <span class="min fw-bold">0</span>
                            - <span class="max fw-bold">0</span>
                            <span class="deposit-currency-symbol"><?php echo e(__(@$singleCurrency->symbol)); ?></span>
                        </span>
                    </li>
                    <li class="list-group-item d-flex flex-wrap justify-content-between">
                        <span><?php echo app('translator')->get('Charge'); ?></span>
                        <span>
                            <span class="charge fw-bold">0</span>
                            <span class="deposit-currency-symbol"><?php echo e(__(@$singleCurrency->symbol)); ?></span>
                        </span>
                    </li>
                    <li class="list-group-item d-flex flex-wrap justify-content-between">
                        <span> <?php echo app('translator')->get('Payable'); ?></span>
                        <span>
                            <span class="payable fw-bold">0</span>
                            <span class="deposit-currency-symbol"><?php echo e(__(@$singleCurrency->symbol)); ?></span>
                        </span>
                    </li>
                </ul>
            </div>
            <button class="deposit__button btn btn--base w-100" type="submit"> <?php echo app('translator')->get('Submit'); ?> </button>
        </form>
        <div class="p-5 text-center empty-gateway <?php if($gateways->count() > 0): ?> d-none <?php endif; ?>">
            <img src="<?php echo e(asset('assets/images/extra_images/no_money.png')); ?>">
            <h6 class="mt-3">
                <?php echo app('translator')->get('No payment gateway available for '); ?>
                <span class="text--base deposit-currency-symbol"><?php echo e(__(@$singleCurrency->symbol)); ?></span>
                <?php echo app('translator')->get('Currency'); ?>
            </h6>
        </div>
    </div>
</div>
<?php $__env->startPush('script'); ?>
    <script>
        "use strict";
        (function($) {

            <?php if(!@$singleCurrency): ?>
                $('.deposit-form').on('submit', function(e) {
                    e.preventDefault();
                    let currency = $(`.deposit-form select[name=currency]`).val();

                    $(`select[name=wallet_type]`).val();


                    let amount = $(`.deposit-form input[name=amount]`).val();

                    if (!currency) {
                        notify('error', "<?php echo app('translator')->get('Currency field is required'); ?>");
                        return false;
                    }

                    if (!amount) {
                        notify('error', "<?php echo app('translator')->get('Amount field is required'); ?>");
                        return false;
                    }

                    let gateways         = <?php echo json_encode($gateways, 15, 512) ?>;
                    let currencyGateways = gateways.filter(ele => ele.currency == currency);
                    

                    if (currencyGateways && currencyGateways.length) {

                        let gatewaysOption = "<option selected disabled> <?php echo app('translator')->get('Select Payment Gateway'); ?></option>";
                        $.each(currencyGateways, function(i, currencyGateway) {
                            gatewaysOption += `
                        <option value="${currencyGateway.method_code}"  data-gateway='${JSON.stringify(currencyGateway)}' >
                                ${currencyGateway.name}
                        </option>`;
                        });

                        $("#deposit-canvas").find(".empty-gateway").addClass('d-none');
                        $("#deposit-canvas").find("form").removeClass('d-none');

                        $("#deposit-canvas").find('select[name=gateway]').html(gatewaysOption);
                        $("#deposit-canvas").find('.deposit-currency-symbol').text(currency);
                        $("#deposit-canvas").find('input[name=currency]').val(currency);
                        $("#deposit-canvas").find(`input[name=amount]`).val(amount);
                    } else {
                        $("#deposit-canvas").find(".empty-gateway").removeClass('d-none');
                        $("#deposit-canvas").find("form").addClass('d-none');
                    }


                    $("#deposit-canvas").find('.deposit-currency-symbol').text(currency);

                    var myOffcanvas = document.getElementById('deposit-canvas');
                    var bsOffcanvas = new bootstrap.Offcanvas(myOffcanvas).show();
                });
            <?php endif; ?>


            $('#deposit-canvas').on('change', 'select[name=gateway]', function() {

                if (!$(this).val()) {
                    $('#deposit-canvas .preview-details').addClass('d-none');
                    return false;
                }

                var resource = $('select[name=gateway] option:selected').data('gateway');
                var fixed_charge = parseFloat(resource.fixed_charge);
                var percent_charge = parseFloat(resource.percent_charge);

                $('#deposit-canvas .min').text(getAmount(resource.min_amount));
                $('#deposit-canvas .max').text(getAmount(resource.max_amount));

                var amount = parseFloat($('#deposit-canvas input[name=amount]').val());
                if (!amount) {
                    $('#deposit-canvas .preview-details').addClass('d-none');
                    return false;
                }

                $('#deposit-canvas .preview-details').removeClass('d-none');

                var charge = parseFloat(fixed_charge + (amount * percent_charge / 100));
                var payable = parseFloat((parseFloat(amount) + parseFloat(charge)));

                $('#deposit-canvas .charge').text(getAmount(charge));
                $('#deposit-canvas .payable').text(getAmount(payable));

                $('#deposit-canvas .method_currency').text(resource.currency);
                $('#deposit-canvas input[name=amount]').on('input');
            });

            $('#deposit-canvas').on('input', 'input[name=amount]', function() {
                var data = $('#deposit-canvas select[name=gateway]').change();
                $('#deposit-canvas .amount').text(parseFloat($(this).val()).toFixed(2));
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/altabxhp/public_html/core/resources/views/templates/basic/user/components/canvas/deposit.blade.php ENDPATH**/ ?>