
<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames(([
    'name'      => 'currency',
    'class'     => 'form-control',
    'id'        => 'currency_list',
    'parent'    => 'currency_list_wrapper',
    'text'      => 'Select Currency',
    'action'    => route('admin.currency.all'),
    'type'      => 'all',
    'valueType' => 1, //1=id,other=symbol
    'multiple' => false,
    'displayType' => 1,
    'disabled' => false
]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter(([
    'name'      => 'currency',
    'class'     => 'form-control',
    'id'        => 'currency_list',
    'parent'    => 'currency_list_wrapper',
    'text'      => 'Select Currency',
    'action'    => route('admin.currency.all'),
    'type'      => 'all',
    'valueType' => 1, //1=id,other=symbol
    'multiple' => false,
    'displayType' => 1,
    'disabled' => false
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars); ?>
<select  name="<?php echo e($name); ?>"  class="<?php echo e($class); ?>" id="<?php echo e($id); ?>" required <?php if($multiple): ?> multiple <?php endif; ?> <?php if($disabled): echo 'disabled'; endif; ?>>
    <?php if(!$multiple): ?>
        <option value="" selected disabled><?php echo e(__($text)); ?></option>
    <?php endif; ?>
</select>

<?php $__env->startPush('script'); ?>
    <script>
        "use strict";
        (function ($) {
            $(`#<?php echo e($id); ?>`).select2({
                ajax: {
                    url: "<?php echo e($action); ?>",
                    type: "get",
                    dataType: 'json',
                    delay: 1000,
                    data: function (params) {
                        return {
                            search: params.term,
                            page: params.page,
                            type:"<?php echo e($type); ?>"
                        };
                    },
                    processResults: function (response, params) {
                        params.page = params.page || 1;
                        let data = response.currencies.data;
                        let valueType=parseInt("<?php echo e($valueType); ?>");
                        let displayType=parseInt("<?php echo e($displayType); ?>");
                        return {
                            results: $.map(data, function (item) {
                                return {
                                    text: displayType == 1 ?  item.name + '-' + item.symbol : item.symbol,
                                    id: valueType != 1 ? item.symbol : item.id,
                                }
                            }),
                            pagination: {
                                more: response.more
                            }
                        };
                    },
                    cache: false,
                },
                dropdownParent: $(`#<?php echo e($parent); ?>`)
            });
        })(jQuery);

    </script>
<?php $__env->stopPush(); ?>


<?php /**PATH /home/altabxhp/public_html/core/resources/views/components/currency-list.blade.php ENDPATH**/ ?>