<?php $__env->startSection('main-content'); ?>
    <?php
        $languages = App\Models\Language::get();
        $content = getContent('login.content', true);
        $policyPages = getContent('policy_pages.element', false, null, true);
        $langDetails = $languages->where('code', config('app.locale'))->first();
        $credentials = gs('socialite_credentials');
    ?>

    <section class="account">
        <div class="account-inner">
            <div class="account-left">
                <a href="<?php echo e(route('home')); ?>" class="account-left__logo">
                    <img src="<?php echo e(getImage(getFilePath('logoIcon') . '/logo_base.png')); ?>">
                </a>
                <div class="account-left__content">
                    <h5 class="account-left__subtitle"><?php echo e(__(@$content->data_values->heading_one)); ?></h5>
                    <h3 class="account-left__title"><?php echo e(__(@$content->data_values->subheading_one)); ?></h3>
                </div>
                <div class="account-left__thumb">
                    <img src="<?php echo e(getImage('assets/images/frontend/login/' . @$content->data_values->image, '600x600')); ?>">
                </div>
            </div>
            <div class="account-right-wrapper">
                <div class="account-content__top">
                    <div class="account-content__member gap-2">
                        <p class="account-content__member-text"> <?php echo app('translator')->get("Don't have an account"); ?>? </p>
                        <a href="<?php echo e(route('user.register')); ?>" class="account-link"><?php echo app('translator')->get('Sign Up'); ?></a>
                        <?php if(gs('multi_language')): ?>
                            <div class="custom--dropdown">
                                <div class="custom--dropdown__selected dropdown-list__item">
                                    <div class="thumb">
                                        <img
                                             src="<?php echo e(getImage(getFilePath('language') . '/' . @$langDetails->flag, getFileSize('language'))); ?>">
                                    </div>
                                    <span class="text"><?php echo e(__(@$langDetails->name)); ?></span>
                                </div>
                                <ul class="dropdown-list">
                                    <ul class="dropdown-list">
                                        <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li class="dropdown-list__item change-lang " data-code="<?php echo e(@$language->code); ?>">
                                                <div class="thumb">
                                                    <img
                                                         src="<?php echo e(getImage(getFilePath('language') . '/' . @$language->flag, getFileSize('language'))); ?>">
                                                </div>
                                                <span class="text"><?php echo e(__(@$language->name)); ?></span>
                                            </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </ul>
                            </div>
                        <?php endif; ?>
                        
                        <div id="google_translate_element"></div>
<script type="text/javascript">
  function googleTranslateElementInit() {
    new google.translate.TranslateElement(
      { pageLanguage: 'en', layout: google.translate.TranslateElement.InlineLayout.HORIZONTAL },
      'google_translate_element'
    );
  }
</script>
<script type="text/javascript" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
                        
                        <div class="theme-switch-wrapper">
                            <label class="theme-switch" for="checkbox">
                                <input type="checkbox" class="d-none" id="checkbox">
                                <span class="slider">
                                    <i class="las la-sun"></i>
                                </span>
                            </label>
                        </div>
                    </div>
                </div>
                <div class="account-right">
                    <div class="account-content">
                        <div class="account-form">
                            <h3 class="account-form__title mb-0"><?php echo e(__(@$content->data_values->heading_two)); ?></h3>
                            <p class="account-form__desc"><?php echo e(__(@$content->data_values->subheading_two)); ?></p>
                            <?php echo $__env->make($activeTemplate . 'partials.social_loign', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


                            <form method="POST" action="<?php echo e(route('user.login')); ?>" class="verify-gcaptcha">
                                <?php echo csrf_field(); ?>
                                <div class="form-group">
                                    <label class="form--label"><?php echo app('translator')->get('Username or Email'); ?></label>
                                    <input type="text" name="username" value="<?php echo e(old('username')); ?>"
                                           class="form--control" placeholder="<?php echo app('translator')->get('Enter your username or email'); ?>">
                                </div>
                                <div class="form-group">
                                    <div class="d-flex justify-content-between">
                                        <label class="form--label"><?php echo app('translator')->get('Password'); ?></label>
                                        <a href="<?php echo e(route('user.password.request')); ?>"
                                           class="forget-password"><?php echo app('translator')->get('Forget Password'); ?>?</a>
                                    </div>
                                    <div class="position-relative">
                                        <input name="password" type="password" class="form--control"
                                               placeholder="<?php echo app('translator')->get('Enter your password'); ?>">
                                        <div class="password-show-hide far fa-eye toggle-password fa-eye-slash"
                                             id="#toogle-password"></div>
                                    </div>
                                </div>
                                <?php if (isset($component)) { $__componentOriginalff0a9fdc5428085522b49c68070c11d6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalff0a9fdc5428085522b49c68070c11d6 = $attributes; } ?>
<?php $component = App\View\Components\Captcha::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('captcha'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Captcha::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['isCustom' => 'true']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalff0a9fdc5428085522b49c68070c11d6)): ?>
<?php $attributes = $__attributesOriginalff0a9fdc5428085522b49c68070c11d6; ?>
<?php unset($__attributesOriginalff0a9fdc5428085522b49c68070c11d6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalff0a9fdc5428085522b49c68070c11d6)): ?>
<?php $component = $__componentOriginalff0a9fdc5428085522b49c68070c11d6; ?>
<?php unset($__componentOriginalff0a9fdc5428085522b49c68070c11d6); ?>
<?php endif; ?>
                                <div class="form-group form-check"><input class="form-check-input" type="checkbox"
                                           name="remember" id="remember" <?php echo e(old('remember') ? 'checked' : ''); ?>>
                                    <label class="form-check-label" for="remember">
                                        <?php echo app('translator')->get('Remember Me'); ?>
                                    </label>
                                </div>
                                <button type="submit" class="btn btn--base w-100"><?php echo app('translator')->get('Log In'); ?></button>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="row gy-3 mt-auto">
                    <div class="col-md-6">
                        <div class="bottom-footer__text">
                            <?php echo copyRightText(); ?>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="bottom-footer__right">
                            <span class="bottom-footer__right-text">
                                <?php $__currentLoopData = $policyPages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $policy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <a class="bottom-footer__right-link" href="<?php echo e(route('policy.pages', $policy->slug)); ?>"
                                       target="_blank">
                                        <?php echo e(__(@$policy->data_values->title)); ?>

                                    </a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/altabxhp/public_html/core/resources/views/templates/basic/user/auth/login.blade.php ENDPATH**/ ?>