<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="card  ">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('Order Date | Pair'); ?></th>
                                    <th><?php echo app('translator')->get('Trade Date'); ?></th>
                                    <th><?php echo app('translator')->get('Trade Side'); ?></th>
                                    <th><?php echo app('translator')->get('Rate'); ?></th>
                                    <th><?php echo app('translator')->get('Amount'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $trades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trade): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td>
                                            <div>
                                                <?php echo e($trade->order->formatted_date); ?>

                                                <br>
                                                <?php echo e(@$trade->order->pair->symbol); ?>

                                            </div>
                                        </td>
                                        <td><?php echo e(showDateTime($trade->created_at)); ?></td>
                                        <td> <?php  echo $trade->tradeSideBadge; ?> </td>
                                        <td>
                                            <?php echo e(showAmount($trade->rate,currencyFormat:false)); ?> <?php echo e(@$trade->order->pair->market->currency->symbol); ?>

                                        </td>
                                        <td> <?php echo e(showAmount($trade->amount,currencyFormat:false)); ?> <?php echo e(@$trade->order->pair->coin->symbol); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <?php if($trades->hasPages()): ?>
                    <div class="card-footer py-4">
                        <?php echo e(paginateLinks($trades)); ?>

                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
    <div class="d-flex flex-wrap gap-2 justify-content-between">
        <?php if (isset($component)) { $__componentOriginale48b4598ffc2f41a085f001458a956d1 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale48b4598ffc2f41a085f001458a956d1 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.search-form','data' => ['placeholder' => 'Pair,coin,currency...']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('search-form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['placeholder' => 'Pair,coin,currency...']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale48b4598ffc2f41a085f001458a956d1)): ?>
<?php $attributes = $__attributesOriginale48b4598ffc2f41a085f001458a956d1; ?>
<?php unset($__attributesOriginale48b4598ffc2f41a085f001458a956d1); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale48b4598ffc2f41a085f001458a956d1)): ?>
<?php $component = $__componentOriginale48b4598ffc2f41a085f001458a956d1; ?>
<?php unset($__componentOriginale48b4598ffc2f41a085f001458a956d1); ?>
<?php endif; ?>
        <form>
            <div class="input-group">
                <select name="trade_side" class="form-control select2" data-minimum-results-for-search="-1">
                    <option value=""><?php echo app('translator')->get('Trade Side'); ?></option>
                    <option value="<?php echo e(Status::BUY_SIDE_ORDER); ?>"><?php echo app('translator')->get('Buy'); ?></option>
                    <option value="<?php echo e(Status::SELL_SIDE_ORDER); ?>"><?php echo app('translator')->get('Sell'); ?></option>
                </select>
                <button class="btn btn--primary input-group-text" type="submit"><i class="la la-search"></i></button>
            </div>
        </form>
    </div>
<?php $__env->stopPush(); ?>


<?php $__env->startPush('script'); ?>
    <script>
        "use strict";
        (function($) {
            $(`select[name=trade_side]`).on('change', function(e) {
                $(this).closest('form').submit();
            });

            <?php if(request()->trade_side): ?>
                $(`select[name=trade_side]`).val("<?php echo e(request()->trade_side); ?>");
            <?php endif; ?>
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/altabxhp/public_html/core/resources/views/admin/order/trade_history.blade.php ENDPATH**/ ?>