<?php
$content  = getContent('faq.content',true);
$elements = getContent('faq.element');
?>

<div class="faq-section py-120 section-bg">
    <div class="container">
        <div class="row gy-4 justify-content-center">
            <div class="col-lg-7 pe-lg-5">
                <div class="section-heading style-left mb-0">
                    <h2 class="section-heading__title"><?php echo e(__(@$content->data_values->heading)); ?></h2>
                    <p class="section-heading__desc"><?php echo e(__(@$content->data_values->subheading)); ?></p>
                </div>
                <div class="faq-thumb l-mood">
                    <img src="<?php echo e(getImage('assets/images/frontend/faq/'.@$content->data_values->image_light,'535x535')); ?>">
                </div>
                <div class="faq-thumb d-mood">
                    <img src="<?php echo e(getImage('assets/images/frontend/faq/'.@$content->data_values->image_dark,'535x535')); ?>">
                </div>
            </div>
            <div class="col-lg-5">
                <div class="accordion custom--accordion" id="accordionExample">
                    <?php $__currentLoopData = $elements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="accordion-item ">
                        <h2 class="accordion-header" id="heading<?php echo e($loop->index); ?>">
                            <button class="accordion-button <?php if(!$loop->first): ?> collapsed <?php endif; ?>" type="button"
                                data-bs-toggle="collapse" data-bs-target="#collaps<?php echo e($loop->index); ?>"
                                aria-expanded="<?php echo e($loop->first ? 'true' : 'false'); ?>"
                                aria-controls="collaps<?php echo e($loop->index); ?>">
                                <?php echo e(__(@$element->data_values->question)); ?>

                            </button>
                        </h2>
                        <div id="collaps<?php echo e($loop->index); ?>" class="accordion-collapse collapse <?php if($loop->first): ?>  show <?php endif; ?>"
                             data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <?php echo e(__(@$element->data_values->answer)); ?>

                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/altabxhp/public_html/core/resources/views/templates/basic/sections/faq.blade.php ENDPATH**/ ?>