<?php
    $meta = (object) $meta;
    $withdrawMethods = $meta->withdrawMethods;
    $singleCurrency = @$meta->single_currency ?? null;
    $walletType = @$meta->wallet_type ?? null;
?>

<div class="offcanvas offcanvas-end p-3 p-md-5" tabindex="-1" id="withdraw-offcanvas">
    <div class="offcanvas-header">
        <h4 class="mb-0 fs-18 offcanvas-title">
            <?php echo app('translator')->get('Withdraw'); ?>
        </h4>
        <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close">
            <i class="fa fa-times-circle"></i>
        </button>
    </div>
    <div class="offcanvas-body">
        <form action="<?php echo e(route('user.withdraw.money')); ?>" method="post" class="<?php if($withdrawMethods->count() <= 0): ?> d-none <?php endif; ?>">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="currency" value="<?php echo e(@$singleCurrency->symbol); ?>">
            <div class="form-group">
                <label class="form-label"><?php echo app('translator')->get('Amount'); ?></label>
                <div class="input-group">
                    <input type="number" step="any" name="amount" value="<?php echo e(old('amount')); ?>" class="form-control form--control" required>
                    <span class="input-group-text text-white withdraw-cur-sym"><?php echo e(__(@$singleCurrency->symbol)); ?></span>
                </div>
            </div>
            <div class="form-group position-relative">
                <label class="form-label"><?php echo app('translator')->get('Method'); ?></label>
                <select class="form-control form--control form-select select2" name="method_code" required
                    data-minimum-results-for-search="-1">
                    <?php if(@$singleCurrency): ?>
                        <?php $__currentLoopData = $withdrawMethods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($method->id); ?>" data-resource='<?php echo json_encode($method, 15, 512) ?>'
                                data-image-src="<?php echo e(getImage(getFilePath('withdrawMethod') . '/' . $method->image)); ?>">
                                <?php echo e(__($method->name)); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </select>
            </div>
            <?php if($walletType): ?>
                <input type="hidden" name="wallet_type" value="<?php echo e($walletType); ?>">
            <?php else: ?>
                <div class="form-group">
                    <label class="form-label"><?php echo app('translator')->get('Wallet Type'); ?></label>
                    <select class="form-control form--control form-select canvas-select2" name="wallet_type" required data-minimum-results-for-search="-1">
                        <option value="" selected disabled><?php echo app('translator')->get('Select One'); ?></option>
                        <?php $__currentLoopData = gs('wallet_types'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $walletType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if(checkWalletConfiguration($k, 'withdraw')): ?>
                                <option value="<?php echo e($k); ?>" for_fiat="<?php echo e(@$walletType->for_fiat); ?>"
                                    for_crypto="<?php echo e(@$walletType->for_crypto); ?>"><?php echo e(__($walletType->title)); ?></option>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            <?php endif; ?>
            <div class="mt-3 preview-details d-none">
                <ul class="list-group text-center list-group-flush">
                    <li class="list-group-item d-flex flex-wrap justify-content-between">
                        <span><?php echo app('translator')->get('Limit'); ?></span>
                        <span>
                            <span class="min fw-bold">0</span>
                            <span class="withdraw-cur-sym"><?php echo e(__(@$singleCurrency->symbol)); ?></span> -
                            <span class="max fw-bold">0</span>
                            <span class="withdraw-cur-sym"><?php echo e(__(@$singleCurrency->symbol)); ?></span>
                        </span>
                    </li>
                    <li class="list-group-item d-flex flex-wrap justify-content-between">
                        <span><?php echo app('translator')->get('Charge'); ?></span>
                        <span>
                            <span class="charge fw-bold">0</span>
                            <span class="withdraw-cur-sym"><?php echo e(__(@$singleCurrency->symbol)); ?></span>
                        </span>
                    </li>
                    <li class="list-group-item d-flex flex-wrap justify-content-between">
                        <span><?php echo app('translator')->get('Receivable'); ?></span>
                        <span>
                            <span class="receivable fw-bold"> 0</span>
                            <span class="withdraw-cur-sym"><?php echo e(__(@$singleCurrency->symbol)); ?></span>
                        </span>
                    </li>
                </ul>
            </div>
            <button type="submit" class="btn btn--base w-100 mt-3"><?php echo app('translator')->get('Submit'); ?></button>
        </form>
        <div class="p-5 text-center empty-gateway <?php if($withdrawMethods->count() > 0): ?> d-none <?php endif; ?>">
            <img src="<?php echo e(asset('assets/images/extra_images/no_money.png')); ?>" alt="">
            <h6 class="mt-3">
                <?php echo app('translator')->get('No withdraw method available for '); ?>
                <span class="text--base withdraw-cur-sym"><?php echo e(__(@$singleCurrency->symbol)); ?></span>
                <?php echo app('translator')->get('Currency'); ?>
            </h6>
        </div>
    </div>
</div>

<?php $__env->startPush('script'); ?>
    <script>
        "use strict";
        (function($) {

            <?php if(!@$singleCurrency): ?>
                $('.withdraw-form').on('submit', function(e) {
                    e.preventDefault();
                    let currency = $(`.withdraw-form select[name=currency]`).val();
                    let amount = $(`.withdraw-form input[name=amount]`).val();

                    if (!currency) {
                        notify('error', "<?php echo app('translator')->get('Currency field is required'); ?>");
                        return false;
                    }

                    if (!amount) {
                        notify('error', "<?php echo app('translator')->get('Amount field is required'); ?>");
                        return false;
                    }

                    let withdrawMethods = <?php echo json_encode($withdrawMethods, 15, 512) ?>;
                    let currencyWithdrawMethods = withdrawMethods.filter(ele => ele.currency == currency);


                    if (currencyWithdrawMethods && currencyWithdrawMethods.length > 0) {
                        let methodsOptions = "<option selected disabled> <?php echo app('translator')->get('Select Method'); ?></option>";

                        $.each(currencyWithdrawMethods, function(i, currencyWithdrawMethod) {
                            methodsOptions += `<option value="${currencyWithdrawMethod.id}" data-resource='${JSON.stringify(currencyWithdrawMethod)}'>
                                    ${currencyWithdrawMethod.name}
                                </option>
                            `;
                        });

                        $("#withdraw-offcanvas").find('select[name=method_code]').html(methodsOptions);
                        $('#withdraw-offcanvas input[name=currency]').val(currency);
                        $('#withdraw-offcanvas input[name=amount]').val(amount);

                        $("#withdraw-offcanvas").find(".empty-gateway").addClass('d-none');
                        $("#withdraw-offcanvas").find("form").removeClass('d-none');

                    } else {
                        $("#withdraw-offcanvas").find(".empty-gateway").removeClass('d-none');
                        $("#withdraw-offcanvas").find("form").addClass('d-none');
                    }


                    $('#withdraw-offcanvas .withdraw-cur-sym').text(currency);
                    var myOffcanvas = document.getElementById('withdraw-offcanvas');
                    var bsOffcanvas = new bootstrap.Offcanvas(myOffcanvas).show();

                });
            <?php endif; ?>

            $('#withdraw-offcanvas').on('change', 'select[name=method_code]', function() {

                if (!$(this).val()) {
                    $('#withdraw-offcanvas .preview-details').addClass('d-none');
                    return false;
                }

                var resource = $('select[name=method_code] option:selected').data('resource');
                var fixed_charge = parseFloat(resource.fixed_charge);
                var percent_charge = parseFloat(resource.percent_charge);

                $('#withdraw-offcanvas  .min').text(getAmount(resource.min_limit));
                $('#withdraw-offcanvas  .max').text(getAmount(resource.max_limit));

                var amount = parseFloat($('#withdraw-offcanvas input[name=amount]').val());

                if (!amount) {
                    $('#withdraw-offcanvas .preview-details').addClass('d-none');
                    return false;
                }

                $('#withdraw-offcanvas .preview-details').removeClass('d-none');

                var charge = parseFloat(fixed_charge + (amount * percent_charge / 100));
                $('#withdraw-offcanvas  .charge').text(getAmount(charge));

                var receivable = parseFloat((parseFloat(amount) - parseFloat(charge)));

                $('#withdraw-offcanvas .receivable').text(getAmount(receivable));

                $('#withdraw-offcanvas .base-currency').text(resource.currency);
                $('#withdraw-offcanvas .method_currency').text(resource.currency);
                $('#withdraw-offcanvas input[name=amount]').on('input');
            });

            $('#withdraw-offcanvas input[name=amount]').on('input', function() {
                var data = $('select[name=method_code]').change();
                $('#withdraw-offcanvas .amount').text(parseFloat($(this).val()).toFixed(2));
            });

        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/altabxhp/public_html/core/resources/views/templates/basic/user/components/canvas/withdraw.blade.php ENDPATH**/ ?>